\version "2.12.0"

#(set-global-staff-size 17)

\paper {
  #(set-paper-size "letter")
  top-margin = 8\mm
}

\header {
	title = "O My Father"
  subtitle = "SATB, Flute, and Piano"
	composer = \markup \override #'(baseline-skip . 3) \right-column {
    "Words: Eliza R. Snow"
    "Music: James McGranahan"
    \concat {\italic "arr." " Andrew Hawryluk"}
    " "
  }
	copyright = \markup \tiny \override #'(baseline-skip . 2.2) \center-column {
    "© 2004 Andrew Hawryluk      www.musicbyandrew.ca"
    "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
    "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"
  }
}

\include "omyfather-defs.ily"

staffFlute = \new Staff  {
	\set Staff.instrumentName="Flute"
	\set Staff.midiInstrument="flute"
	\new Voice = "flutevoice" <<
    \global
    \flutemusic
  >>
}

staffSA = \new Staff = "SA" <<
	\set Staff.instrumentName="S.A."
	\set Staff.midiInstrument="string ensemble 1"
	\new Voice = "sopranovoice" <<
    \global
    \sopranomusic
  >>
  \new Voice = "altovoice" <<
    \altomusic
  >>
>>

staffTB = \new Staff = "TB" <<
  \clef "bass"
	\set Staff.instrumentName="T.B."
	\set Staff.midiInstrument="string ensemble 1"
	\new Voice = "tenorvoice" <<
    \tenormusic
  >>
  \new Voice = "bassvoice" <<
    \global
    \bassmusic
  >>
>>

pianostaff = \new PianoStaff {
  #(set-accidental-style 'piano 'PianoStaff)
  %\set PianoStaff.instrumentName = #"Piano"
	\set PianoStaff.midiInstrument = #"acoustic grand"
	\set PianoStaff.connectArpeggios = ##t
	<<
		\context Staff = "RH" {  % Right hand 
			\set Staff.connectArpeggios = ##t
			<<
			\new Voice << \global \RightHandOne >>
			\new Voice \RightHandTwo
			>>
		}
		\context Staff = "LH" {  % Left hand
      \clef bass
			\set Staff.connectArpeggios = ##t
			<<
			\new Voice \LeftHandOne
			\new Voice << \global \LeftHandTwo >>
			>>
		}
	>>
}

vocals = <<
  \new ChoirStaff <<
    #(set-accidental-style 'modern 'ChoirStaff)
    \override ChoirStaff.LyricText #'font-size = #0.5
    
    \staffSA
    \new Lyrics = "mainLyrics" \lyricsto "sopranovoice" \mainwords
    \new Lyrics = "secondLyrics" \lyricsto "sopranovoice" \secondwords
    \new Lyrics = "thirdLyrics" \lyricsto "sopranovoice" \thirdwords
        
    \staffTB
    \new Lyrics = "tenorLyrics" \with { alignAboveContext = #"TB" } 
        \lyricsto "splitpart" \tenorsoliwords
    \new Lyrics = "lowerLrics" \lyricsto "bassvoice" \basswords
  >>
>>

\book {
  \score {
    <<
      \staffFlute
      \vocals
      \pianostaff
    >>
  
    \midi {
      \context {
      \Score
      tempoWholesPerMinute = #(ly:make-moment 80 4)
      }
    }
    
    \layout {
      \context {
        \RemoveEmptyStaffContext
        \override VerticalAxisGroup #'remove-first = ##t
      }
    }
  }
  \markup \pad-markup #5 {
    \override #'(line-width . 80) \justify {
    \bold {Director’s note:} The first three verses of this piece have
    been left exactly as they appear in the hymn book, with the addition
    of the flute part. I have left the dynamics and other musical
    nuances entirely to your discretion. Have fun!
    }
  }
}

#(set-global-staff-size 18)

#(define output-suffix "vocals")
\book {
  \score {
    <<
      \set Score.skipBars = ##t
      \vocals
    >>
  }
}

#(define output-suffix "piano")
\book {
  \score { 
    \pianostaff
  }
}

#(set-global-staff-size 20)

#(define output-suffix "flute")
\book {
  \paper{ tagline = ""}
  \score { \staffFlute }
}
