\version "2.15.25"

\include "english.ly"

myStaffSize = #19

#(set-global-staff-size myStaffSize)

\paper {
   #(set-paper-size "letter")
   #(define fonts
       (make-pango-font-tree "URW Palladio L"
                          "Nimbus Sans"
                          "Luxi Mono"
                           (/ myStaffSize 20)))
   top-margin = 10\mm
   markup-system-spacing #'basic-distance = #15
}

\header {
  title = "Nearer, My God, to Thee"
  poet = \markup {\italic Text: "Sarah F. Adams"}
  composer = \markup {\italic Music: Lowell Mason}
  arranger = \markup  {\italic arr. Andrew Hawryluk}
	copyright = \markup \tiny \override #'(baseline-skip . 2.2) \center-column {
    "© 2011 Andrew Hawryluk      www.musicbyandrew.ca"
    "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
    "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"
  }
}

global = {
  \key g \major
  s1*50
  \bar "|."
}

rr = {\oneVoice r4 \voiceOne}

tenorImusic = \relative c' {
  \voiceOne
  \dynamicUp
  b2\mp a4 g
  g4. e8 e2
  d2 g4 b
  a2. \rr
  b2 a4 g
  g4. e8 e2
  d4( g) fs a
  g2. \rr
  d'2 e4 d
  d4. b8 d2
  d2 e4 d
  d4. b8 a2
  b2 a4 g
  g4. e8 e2
  d4( g) fs a
  g2. \rr
  
  d'2\mf c4 b
  c4. g8 g2
  g2 b4 d
  d2. \rr
  d2 c4 b
  c4. g8 g2
  g4( b) a c
  b2. \rr
  b2 c4 b
  b4. d8 b2
  b2 c4 b
  d4. d8 d2
  d2\> c4 b
  c4. g8 g2
  g4( b) a c
  b2.\! \rr
  
  b2\mp a4 g
  g4. e8 e2
  d2 g4 b
  a2. s4
  b2 a4 g
  g4. e8 e2
  d4( g) fs a
  g2. \rr
  d'2\mf\< e4 d
  d4.\f b8 d2
  d2 e4 d\>
  d4. b8 a2
  b2\mp a4 g
  g4. e8 e2
  d4( g) fs\< a
  g2. \oneVoice r4\! \voiceOne
  b2\> a4 a
  g1\!
}

tenorIImusic = \relative c' {
  \voiceTwo
  b2 a4 g
  g4. e8 e2
  d2 g4 b
  a2. s4
  b2 a4 g
  g4. e8 e2
  d4( g) fs a
  g2. s4
  b2 c4 b
  b4. g8 b2
  b2 c4 b
  a4. g8 fs2
  g2 fs4 g4
  g4. e8 e2
  d4( g) fs fs
  g2. s4
  
  b2 a4 g
  g4. e8 e2
  d2 g4 b
  a2. s4
  b2 a4 g
  g4. e8 e2
  d4( g) fs a
  g2. s4
  d'2 e4 d
  d4. b8 d2
  d2 e4 d
  d4. b8 a2
  b2 a4 g
  g4. e8 e2
  d4( g) fs a
  g2. s4
  
  b1^( c b a2.) s4
  b1^( c b2 a g2.) s4
  b2 b4 a
  g4. g8 g2
  a4( g) b a
  g4. g8 g4( fs)
  g2 fs4 g4
  g4. e8 e2
  d4( g) fs fs
  g2. s4
  d4( g) fs a
  g1
}

bassImusic = \relative c' {
  \voiceOne
  b2 a4 g
  g4. e8 e2
  d2 g4 b
  a2. \rr
  b2 a4 g
  g4. e8 e2
  d4( g) fs a
  g2. \rr
  g2 g4 g
  g4. g8 g2
  g2 g4 g
  fs4. g8 d2
  d2 d4 d
  e4. c8 c2
  d2 d4 d
  g2. \rr
  
  g2 fs4 e
  e4. c8 c2
  d2 g4 g
  fs2. \rr
  g2 fs4 e
  e4. c8 c2
  d2 d4 fs
  g2. \rr
  g2 g4 g
  g4. g8 g2
  g2 g4 g
  a4. g8 fs2
  g2 fs4 e
  e4. c8 c2
  d2 d4 d
  d2. \rr
  
  d1(^\markup \italic "ah" e g fs2.) \rr
  d1( e2 g2~ g fs g2.) \rr
  fs2 fs4 fs
  e4. e8 e2
  g2 g4 fs
  e4. e8 d2
  d2 d4 d
  e4. c8 c2
  d2 ds4 ds
  e2. \rr
  d4( g) fs fs
  g1
}

bassIImusic = \relative c' {
  \voiceTwo
  b2\mp a4 g
  g4. e8 e2
  d2 g4 b
  a2. s4
  b2 a4 g
  g4. e8 e2
  d4( g) fs a
  g2. s4
  g2 g4 g
  g4. g8 g2
  g2 c,4 g'
  d4. d8 d2
  g,2 a4 b
  c4. c8 c2
  d2 d4 d
  g2. s4
  
  g2\mf d4 e
  c4. c8 c2
  b2 d4 d
  d2. s4
  g2 d4 e
  c4. c8 c2
  b4( d) d d
  g,2. s4
  g2 g4 g
  g4. g8 g2
  g2 c4 g'
  fs4. g8 d2
  g2\> d4 e
  c4. c8 c2
  d2 d4 d
  g,2.\! s4
  
  g1\mp~( g~ g d'2.) s4
  g,1~( g d' g2.) s4
  b,2\mf\< b4 b
  c4.\f c8 c2
  b2 b4 b\>
  c4. c8 d2
  g,2\mp a4 b
  c4. c8 c2
  d2 b4\< b
  e2. s4\!
  d2\> d4 d
  g,1\!
}

words = \lyricmode {
  \override Score . LyricHyphen #'minimum-distance = #0.5
  \override Score . LyricText #'font-size = #0.5
  \set stanza = "1."
  Near -- er, my God, to thee,
  Near -- er to thee!
  E’en though it be a cross
  That rais -- eth me.
  Still all my song shall be
  Near -- er, my God, to thee,
  Near -- er, my God, to thee,
  Near -- er to thee!

  \set stanza = "2."
  Though like the wan -- der -- er,
  The sun gone down,
  Dark -- ness be o -- ver me,
  My rest a stone,
  Yet in my dreams I’d be
  Near -- er, my God, to thee,
  Near -- er, my God, to thee,
  Near -- er to thee!

  \set stanza = "3."
  There let the way ap -- pear,
  Steps un -- to heav’n;
  All that thou send -- est me,
  In mer -- cy giv’n;
  An -- gels to beck -- on me
  Near -- er, my God, to thee,
  Near -- er, my God, to thee,
  Near -- er to thee!
  
  Near -- er to thee!

  \set stanza = "4."
  Then with my wak -- ing thoughts
  Bright with thy praise,
  Out of my ston -- y griefs
  Beth -- el I’ll raise;
  So by my woes to be
  Near -- er, my God, to thee,
  Near -- er, my God, to thee,
  Near -- er to thee!

  \set stanza = "5."
  Or if, on joy -- ful wing
  Cleav -- ing the sky,
  Sun, moon, and stars for -- got,
  Up -- ward I fly,
  Still all my song shall be
  Near -- er, my God, to thee,
  Near -- er, my God, to thee,
  Near -- er to thee!
}

\score { <<
    #(set-accidental-style 'modern 'ChoirStaff)
    \override Score.Clef #'avoid-slur = #'ignore
    \new ChoirStaff <<
      \override ChoirStaff.LyricText #'font-size = #0.5
      \override ChoirStaff.LyricHyphen #'minimum-distance = #0.8
      \new Staff <<
        \set Staff.instrumentName = "T.T."
        \global
        \clef "treble_8"
        \new Voice = "T1" \tenorImusic
        \new Voice = "T2" \tenorIImusic
      >>
      \new Lyrics \with {
        \override VerticalAxisGroup #'staff-affinity = #CENTER
      } \lyricsto "T1" \words
      \new Staff <<
        \set Staff.instrumentName = "B.B."
        \global
        \clef "bass"
        \new Voice = "B1" \bassImusic
        \new Voice = "B2" \bassIImusic
      >>
    >>
  >>
  \layout {}
}