\version "2.19.11"

\include "english.ly"


\header {
  copyright = "2003"
  title = "Jesus, Once of Humble Birth"
  subtitle = "Vocal Solo"
  composer = \markup \override #'(baseline-skip . 2.5) \right-column {
    \line {\italic "Text:" "Parley P. Pratt"}
    \line {\italic "Music:" "Giacomo Meyerbeer"}
    \line {\italic "Arr:" "Andrew Hawryluk"}
  }
  copyright = \markup \tiny \override #'(baseline-skip . 2) \center-column {
              "©2004 Andrew Hawryluk    www.musicbyandrew.ca"
              "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
              "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"}
}

myStaffSize = #17

#(set-global-staff-size myStaffSize)

\paper {
  #(set-paper-size "letter")
  #(define fonts
      (make-pango-font-tree "Linux Libertine O"
                        "Nimbus Sans"
                        "Luxi Mono"
                        (/ myStaffSize 20)))
  top-margin = 8\mm
  bottom-margin = 8\mm
  top-system-spacing #'basic-distance = 7\mm
  last-bottom-spacing #'basic-distance = 7\mm
  top-markup-spacing #`basic-distance = 10\mm
}


PartPOneVoiceOne =  \relative af' {
    \repeat volta 2 {
        \clef "treble" \key df \major \time 3/4 | % 1
        \tempo "Andante"
        R2.*4 | % 5
        af2 f4 | % 6
        af2 f4 | % 7
        af4 ( gf4 ) bf4 | % 8
        ef,2. | % 9
        ef2 f4 | \barNumberCheck #10
        gf2 f4 | % 11
        ef4 ( df4 ) ef4 | % 12
        f2. | % 13
        af2 f4 | % 14
        af2 f4 | % 15
        af4 ( gf4 ) bf4 | % 16
        af2. | % 17
        df2 c4 | % 18
        df2 af4 | % 19
        f2 df4 | \barNumberCheck #20
        af'2. | % 21
        ef2 f4 | % 22
        gf2 f4 | % 23
        ef4 ( df4 ) ef4 | % 24
        df2. }
    | % 25
    R2.*5 | \barNumberCheck #30
    af'2 f4 | % 31
    af2 f4 | % 32
    af4 ( gf4 ) bf4 | % 33
    ef,2. | % 34
    ef2 f4 | % 35
    gf2 f4 | % 36
    ef4 ( df4 ) ef4 | % 37
    f2. | % 38
    af2 f4 | % 39
    af2 f4 | \barNumberCheck #40
    | \barNumberCheck #40
    af4 -\markup{ \italic {cresc.} } ( gf4 ) bf4 | % 41
    af2. | % 42
    df2 c4 | % 43
    df2 af4 | % 44
    f2 df4 | % 45
    af'2. | % 46
    ef2 f4 | % 47
    gf2 f4 | % 48
    ef4 ( df4 ) ef4 | % 49
    df2. | \barNumberCheck #50
    R2.*4 | % 54
    \key e \major b'2 gs4 | % 55
    b2 gs4 | % 56
    b4 ( a4 ) cs4 | % 57
    fs,2. | % 58
    fs2 gs4 | % 59
    a2 gs4 | \barNumberCheck #60
    fs4 ( e4 ) fs4 | % 61
    gs2. | % 62
    b2 gs4 -\markup{ \italic {cresc.} } | % 63
    b2 gs4 | % 64
    b4 ( a4 ) e'4 | % 65
    b2. | % 66
    e2 ds4 | % 67
    e2 b4 | % 68
    gs2 e4 | % 69
    b'2. ^\>| \barNumberCheck #70
    fs2 \! gs4 | % 71
    a2 gs4 | % 72
    fs4 ( e4 ) fs4 | % 73
    e2. | % 74
    R2.*4 | % 78
    fs2 gs4 | % 79
    a2. ~ | \barNumberCheck #80
    a4 r4 gs4 | % 81
    fs4 ( e4 ) fs4 | % 82
    e2. ~ | % 83
    e2. -\markup{ \italic {dim.} } ~ | % 84
    e2. ~ | % 85
    e2. \bar "|."
    }

PartPOneVoiceOneLyricsOne =  \lyricmode {
  \set stanza = #"1."
  Je -- sus, once of hum -- ble birth,
  Now in glo -- ry comes to earth.
  Once he suf -- fered greif and pain;
  Now he comes on earth to reign.
  Now he comes on earth to reign.
  \set stanza = #"3."
  Once he groaned in blood and tears;
  Now in glo -- ry he __ ap -- pears.
  Once re -- jec -- ted by his own,
  Now their King he shall be known.
  Now their King he shall be known.
  \set stanza = #"4."
  Once for -- sak -- en, left a -- lone,
  Now ex -- alt -- ed to __ a throne.
  Once all things he meek -- ly bore,
  But he now will bear no more.
  But he now will bear no more.
  But he now __ will bear no more. __
}

PartPOneVoiceOneLyricsTwo =  \lyricmode {
  \set stanza = #"2."
  Once a meek and low -- ly
  Lamb, Now the Lord, the great I Am. Once up -- on the cross
  he bowed; Now his char -- iot is the cloud. Now his char -- iot
  is __ the cloud.
}

PartPTwoVoiceOne =  \relative af' {
    \repeat volta 2 {
        \clef "treble" \key df \major \time 3/4 | % 1
        \once \override Voice.DynamicText.Y-offset = #10
        <af f'>2 \mp <f df'>4 | % 2
        <af df>2 \voiceOne af4 | % 3
        af4 gf4 f4 | % 4
        ef2. | % 5
        \oneVoice
        <af, df>2 df4 | % 6
        <af c af'>2 df8 c8 | % 7
        \voiceOne
        af'4 gf4 f4 | % 8
        \oneVoice
        ef2. | % 9
        <bf ef>2 df4 | \barNumberCheck #10
        gf2. | % 11
        ef2 df8 ef8 ~ | % 12
        <af, ef' f>2. | % 13
        <af df af'>2 \arpeggio df4 | % 14
        <af c af'>2 \arpeggio df8 c8 | % 15
        \voiceOne
        af'4 gf4 bf4 | % 16
        af2. | % 17
        \oneVoice
        <df, af' df>2 \arpeggio df8 af'8 | % 18
        <df, af' df>2 \arpeggio af'4 | % 19
        <af, bf df f>2. \arpeggio |
        \barNumberCheck #20
        <af df af'>2. \arpeggio | % 21
        <bf df ef>2 f'4 | % 22
        <bf, df gf>2. | % 23
        ef2. | % 24
        df2. }
    | % 25
    <af' f'>2 <f df'>4 | % 26
    <af df>2 <df, af'>4 | % 27
    \voiceOne
    af'4 gf4 f4 | % 28
    \oneVoice
    <gf, df' ef>2. | % 29
    <af c ef>2. \> | \barNumberCheck #30
    | \barNumberCheck #30
    <af df af'>4_\markup{ \italic {delicato} } \arpeggio \!
      <df af' df>4 <ef af c>4 | % 31
    <df af' df>2. \arpeggio | % 32
    \voiceOne
    <df df'>2 df'4 | % 33
    \oneVoice
    <ef, c'>2. | % 34
    <bf ef gf>2 df4 | % 35
    <df gf bf>2. | % 36
    <ef af>2. | % 37
    <f af>2. | % 38
    <af, df>2 df4 | % 39
    <af c af'>2 \arpeggio f'4 | \barNumberCheck #40
    \voiceOne
    af4 _\markup{ \italic {cresc.} } gf4 <gf df'>4 | % 41
    af2. | % 42
    \oneVoice
    <df, af' df>2 <af' c ef>4 | % 43
    <af df f>2 \arpeggio <af df>4 | % 44
    <bf, df f af>2. \arpeggio | % 45
    <af df af'>2. \arpeggio | % 46
    <bf df ef>2 f'4 | % 47
    <bf, df gf>2. | % 48
    ef2. | % 49
    df2. | \barNumberCheck #50
    ef2 f4 | % 51
    gf2 f4 | % 52
    | % 52
    \voiceOne
    ef4 \< <df f>4 <ef gf>4 | % 53
    \oneVoice
    <cf ef gf>4 <cf ff af>4 <cf gf' bff>4 | % 54
    \key e \major <b e b'>2 \! \arpeggio gs'4 | % 55
    <b, ds b'>2 \arpeggio gs'4 | % 56
    \voiceOne
    b4 a4 cs4 | % 57
    \oneVoice
    fs,2. | % 58
    <cs e fs>2 e4 | % 59
    <a, cs e>2. | \barNumberCheck #60
    <e' fs>2 e8 fs8 | % 61
    <b, fs' gs b>2. \arpeggio | % 62
    <b e b'>2 \arpeggio gs'4 _\markup{ \italic {cresc.} } | % 63
    <b, ds b'>2 \arpeggio gs'4 | % 64
    \voiceOne
    b4 a4 cs4 | % 65
    b2. \< | % 66
    \oneVoice
    <e, b' e>2 \f <e b' ds>4 | % 67
    <e b' e>2 <e b'>4 | % 68
    <b cs e gs>2. | % 69
    <b e b'>2. \> \arpeggio | \barNumberCheck #70
    <cs e fs>2 \mp gs'4 | % 71
    <cs, e a>2. | % 72
    fs2. | % 73
    e2. | % 74
    <e b' e>2 \arpeggio ds'4 | % 75
    <e, b' e>2 \arpeggio b'4 | % 76
    <b, cs e gs>2. \arpeggio | % 77
    \voiceOne
    <b b'>2. \arpeggio | % 78
    \oneVoice
    <cs e fs>2 gs'4 | % 79
    <cs, e a>2. | % 79
    | \barNumberCheck #80
    \voiceOne
    <e' b'>2 \oneVoice r4 | % 81
    R2. \voiceOne | % 82
    b2 \arpeggio gs4 _\markup{ \italic {dim.} } | % 83
    b2 \arpeggio gs4 | % 84
    b4 \arpeggio a4 cs4 | % 85
    \oneVoice
    <gs, e' b'>2. \arpeggio \bar "|."
    }

PartPTwoVoiceThree =  \relative af, {
    \repeat volta 2 {
        \clef "bass" \key df \major \time 3/4 r8 af8 df8 f8 af8 df8 | % 2
        r8 df,8 f8 af8 df4 | % 3
        r8 bf,8 ef8 bf8 ef8 gf8 | % 4
        r8 ef8 af8 bf8 \parenthesize c4 | % 5
        r8 af,8 f'8 af,8 r8 af8 | % 6
        r8 af8 f'8 af,8 r8 af8 | % 7
        r8 bf4 ef4 gf8 | % 8
        r8 ef8 af8 bf8 c8 df8 | % 9
        r8 df,8 gf8 bf8 ~ bf4 | \barNumberCheck #10
        r8 bf,8 ef8 gf8 bf8 df8 | % 11
        r8 ef,8 af8 bf8 ~ bf4 | % 12
        r8 af,8 df8 f8 af8 df8 | % 13
        r8 af,8 f'8 af,8 r8 af8 | % 14
        r8 af8 f'8 af,8 r8 af8 | % 15
        r8 bf4 ef4 gf8 | % 16
        r8 df4 f4 f8 | % 17
        r8 f8 bf8 f8 bf8 f8 | % 18
        r8 f8 af8 f8 af8 f8 | % 19
        r8 df8 gf8 af8 bf8 df8 | \barNumberCheck #20
        r8 df,8 f8 af8 df8 af'8 | % 21
        r8 df,,8 gf8 bf8 ~ bf4 | % 22
        r8 bf,8 ef8 gf8 bf8 df8 | % 23
        r8 ef,8 af8 bf8 c4 | % 24
        r8 af,8 f'8 ef8 df8 af8 }
    | % 25
    r8 af8 df8 f8 af8 df8 | % 26
    r8 df,8 f8 af8 \parenthesize <df>8 c8 | % 27
    r8 df,8 gf8 bf8 r8 bf,8 | % 28
    r8 gf8 cf8 ef8 gf8 df'8 | % 29
    r8 af,8 ef'8 af8 c8 ef8 | \barNumberCheck #30
    r8 af,,8 f'8 af8 df4 | % 31
    r8 f,,8 bf8 df8 f8 af8 | % 32
    r8 bf,4 ef4 gf8 | % 33
    r8 ef8 af8 bf8 c8 df8 | % 34
    r8 df,8 gf8 bf8 ~ bf4 | % 35
    r8 bf,8 ef8 gf8 bf8 df8 | % 36
    r8 ef,8 af8 bf8 c4 | % 37
    r8 af,8 df8 f8 af8 df8 | % 38
    r8 af,8 f'8 af,8 r8 af8 | % 39
    r8 af8 f'8 af,8 r8 af8 | \barNumberCheck #40
    r8 bf4 ef4 gf8 | % 41
    r8 df4 f4 f8 | % 42
    r8 f8 bf8 f8 bf8 f8 | % 43
    r8 f8 af8 f8 af8 f8 | % 44
    r8 df8 gf8 af8 bf8 df8 | % 45
    r8 df,8 f8 af8 df8 af'8 | % 46
    r8 df,,8 gf8 bf8 ~ bf4 | % 47
    r8 bf,8 ef8 gf8 bf8 df8 | % 48
    r8 ef,8 af8 bf8 c4 | % 49
    r8 af,8 f'8 ef8 df8 af8 | \barNumberCheck #50
    r8 df8 gf8 bf8 ~ bf4 | % 51
    r8 bf,8 ef8 gf8 bf4 | % 52
    r8 gf,8 cf8 gf8 cf8 gf8 | % 53
    r8 gf8 cf8 gf8 cf8 gf8 | % 54
    \key e \major r8 b8 gs'8 b,8 r8 b8 | % 55
    r8 b8 gs'8 b,8 r8 b8 | % 56
    r8 cs4 fs4 a8 | % 57
    r8 fs8 b8 cs8 ds8 e8 | % 58
    r8 e,8 a8 cs8 ~ cs4 | % 59
    r8 cs,8 fs8 a8 cs8 e8 | \barNumberCheck #60
    r8 fs,8 b8 cs8 ~ cs4 | % 61
    r8 b,8 gs'8 fs8 e8 b8 | % 62
    r8 b8 gs'8 b,8 r8 b8 | % 63
    r8 b8 gs'8 b,8 r8 b8 | % 64
    r8 cs8 fs8 cs8 a'8 cs,8 | % 65
    r8 e8 gs8 e8 gs8 e8 | % 66
    r8 gs8 cs8 gs8 cs8 gs8 | % 67
    r8 gs8 b8 gs8 b8 gs8 | % 68
    r8 e8 a8 b8 cs8 e8 | % 69
    r8 e,8 gs8 b8 e8 b'8 | \barNumberCheck #70
    r8 e,,8 a8 cs8 ~ cs4 | % 71
    r8 cs,8 fs8 a8 cs8 e8 | % 72
    r8 fs,8 b8 cs8 ds4 | % 73
    r8 b,8 gs'8 fs8 e8 ds8 | % 74
    r8 gs8 cs8 gs8 cs8 gs8 | % 75
    r8 gs8 b8 gs8 r8 gs8 | % 76
    r8 e8 a8 b8 cs8 e8 | % 77
    r8 e,8 gs8 e8 gs8 e8 | % 78
    r8 e8 a8 cs8 ~ cs4 | % 79
    | % 79
    r8 \sustainOn cs,8 fs8 a8 cs8 e8 s2 s4 \sustainOff | % 81
    r8 fs,8 b8 cs8 ds4 | % 82
    r8 b,8 gs'8 b,8 r8 b8 | % 83
    r8 b8 gs'8 b,8 r8 b8 | % 84
    r8 a4 e'4 fs8 | % 85
    <e, b' e>2. \arpeggio \bar "|."
    }

PartPTwoVoiceTwo =  \relative f' {
    \repeat volta 2 {
        \clef "treble" \key df \major \time 3/4 | % 1
        s4*5 f8 ef8 | % 3
        <bf df>2. | % 4
        df2 ( c4 ) s1. | % 7
        <bf df>2. s4*21 | % 15
        <bf df>2. | % 16
        ef4 ( df4 c4 ) s1*6 }
    s4*5 s4 | % 27
    <bf df>2 <bf df>4 s1. | \barNumberCheck #30
    s1. | % 32
    af'4 gf4 f4 s2*10 s4 | \barNumberCheck #40
    <bf, df>2. | % 41
    ef4 ( df4 c4 ) s2*15 | % 52
    cf2 cf4 s2. | % 54
    \key e \major s1. | % 56
    <cs e>2. s4*17 s1 | % 64
    <cs e>2. | % 65
    fs4 ( e4 ds4 ) | % 66
    s1*3 | \barNumberCheck #70
    s4*21 | % 77
    fs4 e4 ds4 s2. | % 79
    s2. | \barNumberCheck #80
    a'2 s4 s2. | % 82
    <b, e>2. \arpeggio | % 83
    <b ds>2. \arpeggio | % 84
    <cs e>2. \arpeggio
    }

PartPTwoVoiceFour =  \relative df, {
    \repeat volta 2 {
        \clef "bass" \key df \major \time 3/4 df2. | % 2
        f2. | % 3
        ef2. | % 4
        af2. | % 5
        df,2. | % 6
        df2. | % 7
        ef2. | % 8
        af2. | % 9
        gf2 r8 f8 | \barNumberCheck #10
        ef2. | % 11
        af2. | % 12
        df,2. | % 13
        df2. | % 14
        df2. | % 15
        ef2. | % 16
        f2. | % 17
        bf2. | % 18
        af2. | % 19
        gf2. | \barNumberCheck #20
        f2. | % 21
        gf2 r8 f8 | % 22
        ef2. | % 23
        af2. | % 24
        df,2. }
    | % 25
    df2. | % 26
    f2. | % 27
    gf2 bf,4 | % 28
    cf2. | % 29
    af2. | \barNumberCheck #30
    df2. | % 31
    bf2. | % 32
    ef2. | % 33
    af2. | % 34
    gf2 r8 f8 | % 35
    ef2. | % 36
    af2. | % 37
    df,2. | % 38
    df2. | % 39
    df2. | \barNumberCheck #40
    ef2. | % 41
    f2. | % 42
    bf2. | % 43
    af2. | % 44
    gf2. | % 45
    f2. | % 46
    gf2 r8 f8 | % 47
    ef2. | % 48
    af2. | % 49
    df,2. | \barNumberCheck #50
    gf2 r8 f8 | % 51
    ef2 r8 df8 | % 52
    cf2. | % 53
    cf2. | % 54
    \key e \major <e, e'>2. | % 55
    e'2. | % 56
    fs2. | % 57
    b2. | % 58
    a2 r8 gs8 | % 59
    fs2. | \barNumberCheck #60
    b2. | % 61
    e,2. | % 62
    e2. | % 63
    e2. | % 64
    fs2. | % 65
    gs2. | % 66
    <cs, cs'>2. | % 67
    <b b'>2. | % 68
    <a a'>2. | % 69
    gs'2. | \barNumberCheck #70
    a2 r8 gs8 | % 71
    fs2. | % 72
    b2. | % 73
    e,2. | % 74
    cs'2. | % 75
    b2. | % 76
    a2. | % 77
    gs2. | % 78
    a2 r8 gs8 | % 79
    | % 79
    fs2. \sustainOn ~ | \barNumberCheck #80
    fs2 \oneVoice r4 \sustainOff \voiceTwo | % 81
    b2. | % 82
    e,2. | % 83
    e2. | % 84
    e2.
    }


\book {% The score definition
  \score {
    <<
        \new Staff <<
            <<
	      \set Staff.midiInstrument = #"oboe"
              \context Voice = "PartPOneVoiceOne" { \PartPOneVoiceOne }
              \new Lyrics \lyricsto "PartPOneVoiceOne" \PartPOneVoiceOneLyricsOne
              \new Lyrics \lyricsto "PartPOneVoiceOne" \PartPOneVoiceOneLyricsTwo
            >>
          >>
        \new PianoStaff <<
          \new Staff \with { \consists "Span_arpeggio_engraver" }
              <<
                \set Staff.connectArpeggios = ##t
                \context Voice = "PartPTwoVoiceOne" { \PartPTwoVoiceOne }
                \context Voice = "PartPTwoVoiceTwo" { \voiceTwo \PartPTwoVoiceTwo }
              >>
          \new Staff <<
                \context Voice = "PartPTwoVoiceThree" { \voiceOne \PartPTwoVoiceThree }
                \context Voice = "PartPTwoVoiceFour" { \voiceTwo \PartPTwoVoiceFour }
                >>
            >>
        
        >>
    \layout {
      \context {
        \Voice
        \override ParenthesesItem.font-size = #-3
      }
    }
    % To create MIDI output, uncomment the following line:
    \midi {
      \tempo 4 = 72
    }
  }
}
  
\book {% The score definition
  \bookOutputSuffix "piano"
  \header {
    piece = "Piano Accompaniment"
  }
  \score {
    <<
        \new PianoStaff <<
          \new Staff \with { \consists "Span_arpeggio_engraver" }
              <<
                \set Staff.connectArpeggios = ##t
                \context Voice = "PartPTwoVoiceOne" { \PartPTwoVoiceOne }
                \context Voice = "PartPTwoVoiceTwo" { \voiceTwo \PartPTwoVoiceTwo }
              >>
          \new Staff <<
                \context Voice = "PartPTwoVoiceThree" { \voiceOne \PartPTwoVoiceThree }
                \context Voice = "PartPTwoVoiceFour" { \voiceTwo \PartPTwoVoiceFour }
                >>
            >>
        
        >>
    \layout {
      \context {
        \Voice
        \override ParenthesesItem.font-size = #-3
      }
    }
  }
}
