% Created on Wed Dec 26 18:54:54 GMT 2007
\version "2.14.0"

myStaffSize = #18
#(set-global-staff-size myStaffSize)

\paper {
  #(set-paper-size "letter")
  #(define fonts
    (make-pango-font-tree "URW Palladio L"
                          "Nimbus Sans"
                          "Luxi Mono"
                          (/ myStaffSize 20)))
  ragged-last-bottom = ##f
  top-margin = 10\mm
}

\header {
        title = "I Know That My Redeemer Lives"
        subtitle = "Women’s choir and piano"
        poet = \markup {\italic Text: Samuel Medley}
        composer = \markup {\italic Music: Lewis D. Edwards}
        arranger = \markup  {\italic arr. Andrew Hawryluk }
        copyright = \markup \tiny \override #'(baseline-skip . 2.5) \center-column {
          ""
          ""
          "©2008 Andrew Hawryluk    www.musicbyandrew.ca"
          "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
          "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"
        }
}

\include "iknowthatmyredeemerSSA-defs.ily"

\layout { \context { \Staff \RemoveEmptyStaves } }

\book{
  \score {
          <<
                  \override Score.PaperColumn #'keep-inside-line = ##t
                  \override Score.VerticalAxisGroup #'remove-first = ##t
                  \new ChoirStaff
                  <<
                          \set ChoirStaff.midiInstrument = #"voice oohs"
                          \new Staff = "UpperVoice" <<
                                  \global
                                  \new Voice = "highharmony" << \HighHarmony \dynamicsUpper >>
                          >>
                          \new Lyrics \lyricsto "highharmony" {\upperwords}
                          \new Staff = "LowerVoice" <<
                                  \global
                                  \new Voice = "melody" { \Melody }
                                  \new Voice = "lowharmony" << \LowHarmony \dynamicsLower>>
                                  >>
                          \new Lyrics \lyricsto "melody" {\mainwords}
                  >>
                  \new PianoStaff {
                          \set PianoStaff.midiInstrument = #"acoustic grand"
                          \set PianoStaff.connectArpeggios = ##t
                          <<
                          \context Staff = "RH" {  % Right hand 
                                  \set Staff.connectArpeggios = ##t
                                  <<
                                  \new Voice << \global \RightHandOne \dynamicsUpper \dynamicsLower>>
                                  \new Voice {\voiceTwo \RightHandTwo}
                                  >>
                          }
                          \context Staff = "LH" {  % Left hand
                                  \set Staff.connectArpeggios = ##t
                                  \set Staff.pedalSustainStyle = #'bracket
                                  <<
                                  \new Voice << \global \voiceOne \LeftHandOne >>
                                  \new Voice {\LeftHandTwo}
                                  >>
                          }
                          >>
                  }
          >>

          \midi { }

          \layout {
                  \context { \Staff \RemoveEmptyStaves }
                  \context {
                          \Staff
                          \consists Span_arpeggio_engraver
                  }
          }
  }
}


myStaffSize = #17
#(set-global-staff-size myStaffSize)

\book {
  \bookOutputSuffix "choir"
  \paper {
    #(define fonts
    (make-pango-font-tree "URW Palladio L"
                          "Nimbus Sans"
                          "Luxi Mono"
                          (/ myStaffSize 20)))
  }
        \score {<<
                \compressFullBarRests
                \override Score.PaperColumn #'keep-inside-line = ##t
                \override Score.MultiMeasureRest #'expand-limit = 1
                \override Score.VerticalAxisGroup #'remove-first = ##t
                \new ChoirStaff
                <<
                        \set ChoirStaff.midiInstrument = #"voice oohs"
                        \new Staff = "UpperVoice" <<
                                \global
                                \new Voice = "highharmony" << \HighHarmony \dynamicsUpper >>
                        >>
                        \new Lyrics \lyricsto "highharmony" {\upperwords}
                        \new Staff = "LowerVoice" <<
                                \global
                                \new Voice = "melody" { \Melody }
                                \new Voice = "lowharmony" << \LowHarmony \dynamicsLower>>
                        >>
                        \new Lyrics \lyricsto "melody" {\mainwords}
                >>
        >>}
}

\book{
  \bookOutputSuffix "piano"
  \paper {
    #(define fonts
    (make-pango-font-tree "URW Palladio L"
                          "Nimbus Sans"
                          "Luxi Mono"
                          (/ myStaffSize 20)))
  }
        \score {<<
                \override Score.PaperColumn #'keep-inside-line = ##t
                \new PianoStaff {
                        \set PianoStaff.midiInstrument = #"acoustic grand"
                        \set PianoStaff.connectArpeggios = ##t
                        <<
                        \context Staff = "RH" {  % Right hand 
                                \set Staff.connectArpeggios = ##t
                                <<
                                \new Voice << \global \RightHandOne \dynamicsUpper \dynamicsLower>>
                                \new Voice {\voiceTwo \RightHandTwo}
                                >>
                        }
                        \context Staff = "LH" {  % Left hand
                                \set Staff.connectArpeggios = ##t
                                \set Staff.pedalSustainStyle = #'bracket
                                <<
                                \new Voice << \global \voiceOne \LeftHandOne >>
                                \new Voice {\LeftHandTwo}
                                >>
                        }
                        >>
                }
        >>}
}
