\version "2.18.0"

\include "english.ly"

myStaffSize = #20

#(set-global-staff-size myStaffSize)

\paper {
   #(set-paper-size "letter")
   #(define fonts
       (make-pango-font-tree "URW Palladio L"
                          "Nimbus Sans"
                          "Luxi Mono"
                           (/ myStaffSize 20)))
   top-margin = 10\mm
}

\header {
  title = "Sweet Hour of Prayer"
  subtitle = "TBB"
  poet = \markup {\italic Text: William W. Walford (attr.)}
  composer = \markup {\italic Music: William B. Bradley}
  arranger = \markup  {\italic arr. Andrew Hawryluk}
  copyright = \markup \tiny \override #'(baseline-skip . 2.5) \center-column {
    "©2006 Andrew Hawryluk    www.musicbyandrew.ca"
    "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
    "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"
  }
  tagline = #f
}

global = {
  \key ef \major
  \time 6/8
  \partial 8
}

tenor = \relative c {
  ef8 g4 af8 bf4 bf8 c4 d8 ef4
  c8 bf4 g8 g( f) ef f4 g8 f4
  ef8 g4 af8 bf4 bf8 c4 d8 ef4
  c8 bf4 g8 g4 ef8 g4 f8 ef4
  bf'8 ef4 d8 ef4 c8 bf4 g8 bf4
  bf8 ef4 d8 ef4 c8 bf4 g8 f4
  ef8 g4 af8 bf4 bf8 c4 d8 ef4
  c8 bf4 g8 g( f) ef f4 g8 f4
  ef8 g4 af8 bf4 bf8 c4 d8 ef4\fermata
  c8 bf4 g8 g4 ef8 g4 f8 ef4\fermata
  \bar "|."
}

baritone = \relative c {
  \voiceOne
  ef8 ef4 f8 g4 g8 af4 bf8 c4
  af8 g4 ef8 ef4 ef8 ef4 ef8 d4
  ef8 ef4 f8 g4 g8 af4 bf8 c4
  af8 g4 ef8 ef4 ef8 ef4 d8 ef4
  bf'8 bf4 bf8 bf4 af8 g4 g8 af4
  f8 g4 g8 c4 af8 g4 ef8 d4
  ef8 ef4 f8 g4 g8 af4 bf8 c4
  af8 g4 ef8 ef4 ef8 ef4 ef8 d4
  ef8 ef4 f8 g4 g8 af4 bf8 c4%\fermata
  af8 g4 ef8 ef4 ef8 ef4 d8 ef4%\fermata
}

bass = \relative c {
  \voiceTwo
  ef8 ef4 ef8 ef4 ef8 af4 af8 af4
  ef8 ef4 ef8 ef4 bf8 bf4 bf8 bf4
  ef8 ef4 ef8 ef4 ef8 af4 af8 af4
  ef8 ef4 ef8 ef4 c8 bf4 bf8 ef4
  ef8 ef4 f8 g4 ef8 ef4 ef8 ef4
  d8 c4 ef8 af4 ef8 ef4 bf8 bf4
  ef8 ef4 ef8 ef4 ef8 af4 af8 af4
  ef8 ef4 ef8 ef4 bf8 bf4 bf8 bf4
  ef8 ef4 ef8 ef4 ef8 af4 af8 af4\fermata
  ef8 ef4 ef8 ef4 c8 bf4 bf8 ef4\fermata
}

prayer = \lyricmode {
  \once \override LyricText #'self-alignment-X = #-0.2 prayer!
}

verseOne = \lyricmode {
  \set stanza = "1."
  Sweet hour of \prayer
  Sweet hour of \prayer
  That calls me from a world of care
  And bids me at my Fa -- ther’s throne
  Make all my wants and wish -- es known.
  In sea -- sons of dis -- tress and grief,
  My soul has of -- ten found re -- lief
  And oft es -- caped the tempt -- er’s snare
  By thy re -- turn, sweet hour of \prayer
  And oft es -- caped the tempt -- er’s snare
  By thy re -- turn, sweet hour of \prayer
}

verseTwo = \lyricmode {
  \set stanza = "2."
  Sweet hour of \prayer
  Sweet hour of \prayer
  Thy wings shall my pe -- ti -- tion bear
  To him whose truth and faith -- ful -- ness
  En -- gage the wait -- ing soul to bless.
  And since he bids me seek his face,
  Be -- lieve his word, and trust his grace,
  I’ll cast on him my ev -- ’ry care,
  And wait for thee, sweet hour of \prayer
  I’ll cast on him my ev -- ’ry care,
  And wait for thee, sweet hour of \prayer
}

\score {
  \new ChoirStaff \with {
    \override LyricHyphen #'minimum-distance = #1 }
  <<
    \override ChoirStaff.LyricText #'font-size = #0.5
    \new Staff <<
      \global
      \set Staff.instrumentName = #"T."
      \clef "treble_8"
      \new Voice = "tenor" \tenor
    >>
    \new Lyrics \with {
      \override VerticalAxisGroup #'staff-affinity = #CENTER
    } \lyricsto "tenor" \verseOne
    \new Lyrics \with {
      \override VerticalAxisGroup #'staff-affinity = #CENTER
    } \lyricsto "tenor" \verseTwo
    \new Staff <<
      \global
      \set Staff.instrumentName = #"B.B."
      \clef bass
      \new Voice = "baritone" \baritone
      \new Voice = "bass" \bass
    >>
  >>
  \layout { }
  \midi { }
}
