\version "2.11.49"

\include "english.ly"

myStaffSize = #19

#(set-global-staff-size myStaffSize)

\paper {
   #(set-paper-size "letter")
   #(define fonts
       (make-pango-font-tree "URW Palladio L"
                          "Nimbus Sans"
                          "Luxi Mono"
                           (/ myStaffSize 20)))
   top-margin = 10\mm
}

\header {
	title = "Guide Us, O Thou Great Jehovah"
  subtitle = "TTBB"
	poet = \markup {\italic Text: William and Peter Williams}
	composer = \markup {\italic Music: John Hughes}
	arranger = \markup  {\italic arr. Andrew Hawryluk}
	copyright = \markup \tiny \override #'(baseline-skip . 2.5) \center-column {
              "©2005 Andrew Hawryluk    www.musicbyandrew.ca"
              "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
              "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"
	}
}

global = {
  \phrasingSlurDashed
  \key af \major
  \override Score.RehearsalMark #'break-align-symbols = #'(time-signature)
  \override Score.RehearsalMark #'self-alignment-X = #-1
  \override Score.TimeSignature #'break-align-anchor-alignment = #LEFT
  \mark \markup \large \bold "Fervently"
  s1*28
  \bar "||"
  \key bf \major
  \override Score.RehearsalMark #'break-align-symbols = #'(key-signature)
  \override Score.RehearsalMark #'self-alignment-X = #-1
  \override Score.TimeSignature #'break-align-anchor-alignment = #RIGHT
  \mark \markup \large \bold "Boldly"
  s1*15
  \bar "|."
}

tenorOne = \relative c <<
  \global
  {
    ef4 f ef4. af8
    af8( g) af( bf) c4 bf
    c4 af f df'
    c bf af2
    ef4 f ef4. af8
    af8( g) af( bf) c4 bf
    c df ef df8( bf)
    af4 g af2
    \voiceOne
    bf4.^\markup \italic \tiny div. c8 df4 bf
    c4. df8 ef4 c
    ef4. ef8 df c bf af
    \voiceTwo g4 g8 bf df2
    \voiceOne
    ef4. df8 c( ef) df( bf)
    af4 g af2\fermata
    
    c4 df c4. c8
    c8( bf) c( df) ef4 ef
    ef c df f
    ef ef c2
    c4 df c4. c8
    c8( bf) c( df) ef4 ef\(
    ef\) ef ef df
    c bf af2
    \voiceTwo
    bf4. c8 df4 bf
    c4. df8 ef4 \voiceOne ef\(
    ef4.\)^\markup \italic \tiny melody \breathe ef8 df c bf af
    << {\hideNotes ef4 ef8 ef ef2 \unHideNotes}
        \new Voice {\voiceOne ef'1} >>
    ef4. df8 c( ef) df( bf)
    af4 g af2\fermata
    
    f4 g f4. bf8
    bf8( a) bf( c) d4 c
    d bf g ef'
    d c bf2
    f4 g f4. bf8
    bf8( a) bf( c) d4 c
    d ef f ef8( c)
    d4 c bf2
    c4. d8 ef4 c
    d4. ef8 f4 d
    f4. f8 ef d c bf
    \voiceTwo
    bf4 ef8 d c2
    \voiceOne
    f4. ef8 d( f) ef( c)
    \voiceTwo
    d2 c4.^( ef8)
    \voiceOne
    d1 \fermata
  }
>>

tenorTwo = \relative c' <<
  \global
  {
    \voiceTwo
    s1*8
    g4. af8 bf4 g
    af4. bf8 c4 af
    c4. c8 bf af af af
    \voiceOne ef'1
    \voiceTwo
    c4. bf8 af4 bf
    c bf8( df) c2
    
    ef,4_\markup \italic \tiny melody f ef4. af8
    af8( g) af( bf) c4 bf
    c4 af f df'
    c bf af2
    ef4 f ef4. af8
    af8( g) af( bf) c4 bf\(
    c\) df ef df8( bf)
    af4 g af2
    \voiceOne
    r4 ef'8 ef ef4 ef
    r4 ef8 ef ef4
    %bf4. c8 df4 bf
    %c4. df8 ef4 c
    \voiceTwo c4\(
    c4.\) c8 bf af af af
    bf1
    c4. bf8 af4 bf
    c4 bf8 df c2
    
    f,4 g f4. f8
    f4 bf bf a
    bf f g bf
    bf a f2
    d4 ef d4. f8
    f4 bf bf a
    bf c d c 
    bf a f2
    a4. bf8 c4 c
    bf4. c8 d4 bf
    d4. d8 c8 bf bf bf
    \voiceOne f'1 \voiceTwo
    c4. c8 bf4 bf
    \voiceOne
    bf2. a4
    \voiceTwo bf1
  }
>>

baritone = \relative c <<
  \global
  {
    ef4 f ef4. af8
    af8( g) af( bf) c4 bf
    c4 af f df'
    c bf af2
    ef4 f ef4. af8
    af8( g) af4 af g
    af^\markup \italic \tiny div. \voiceOne af af f
    ef ef af2
    ef4. ef8 ef4 ef
    ef4. ef8 af4 ef
    af4. af8 f f f f 
    ef4 ef8 f g2
    af4. f8 ef4 f
    ef ef ef2
    
    af4 af af4. ef8
    ef4 af af g
    af af af af
    af g af2
    af4 af af4. ef8
    ef4 af af g\(
    af\) af af f
    ef g af2
    \oneVoice r4 \voiceOne g8 af bf4 g
    \oneVoice r4 \voiceOne af8 bf c4 af\(
    af4.\) \breathe af8 f f f f
    af4 f8 af g2
    af4. f8 ef4 f
    ef ef ef2
    
    f4 ef d ef
    d8( ef) f4 f f
    f d ef g
    f f d2
    bf4 bf bf4. d8
    d8( ef) f4 f f
    bf4 bf bf g
    f f d2
    f4. f8 f( g)a4
    bf4. bf8 bf4 f
    bf4. bf8 g g g g
    g4 g8 bf bf4( a)
    a4. a8 bf4 g
    f2 f f1
  }
>>

bass = \relative c <<
  \global
  {
    \voiceTwo
    s1*6
    s4 f c df
    ef ef af2
    ef4. ef8 ef4 ef
    af,4. af8 af4 af
    af4. af8 bf bf df df
    ef1
    af,4. bf8 c4 df
    ef ef af,2\fermata
    
    af4 af af4. af8
    af4 f' ef ef
    af, af df bf
    ef ef af,2
    af4 af af4. af8
    af4 f' ef ef\(
    af\) f c df
    ef g af2
    s4 ef8 ef ef( f) g4
    s4 af8 af af4 af\(
    af,4.\) af8 bf bf df df
    ef1
    af,4. bf8 c4 df
    ef ef af,2\fermata
    
    f'4 ef d c
    bf8( c) d( ef) f4 f
    bf, bf ef c
    f f, bf2
    bf4 bf bf4. bf8
    bf8( c) d( ef) f4 f
    bf bf bf ef,
    f f bf,2
    f'4. f8 f4 f
    bf4. f8 bf,4 bf
    bf4. bf8 c c ef ef
    ef4 ef8 ef f2
    d4. f8 g4 c,8( ef)
    f2 f
    bf,1\fermata
  }
>>

words = \lyricmode {
  Guide us, O thou great Je -- ho -- vah,
  Guide us to the prom -- ised land.
  We are weak, but thou art a -- ble;
  Hold us with thy pow’r -- ful hand.
  Ho -- ly Spir -- it, Ho -- ly Spir -- it,
  Feed us till the Sav -- ior comes,
  Sav -- ior comes,
  Feed us till the Sav -- ior comes.
  
  O -- pen, Je -- sus, Zi -- on’s foun -- tains;
  Let her rich -- est bles -- sings come.
  Let the fi -- ery, cloud -- y pil -- lar
  Guard us to this ho -- ly home.
  Great Re -- deem -- er, Great Re -- deem -- er,
  Bring, oh, bring the wel -- come day, wel -- come day,
  Bring, oh, bring the wel -- come day!
  
  When the earth be -- gins to trem -- ble,
  Bid our fear -- ful thoughts be still;
  When thy judg -- ments spread de -- struc -- tion,
  Keep us safe on Zi -- on’s hill,
  Sing -- ing prais -- es, Sing -- ing prais -- es,
  Songs of glo -- ry un -- to thee, un -- to thee,
  Songs of glo -- ry un -- to thee.
}

\new ChoirStaff <<
  #(set-accidental-style 'modern 'ChoirStaff)
  \override ChoirStaff.LyricText #'font-size = #0.5
  \new Staff <<
    \set Staff.instrumentName = #"T.T."
    \clef "treble_8"
    \new Voice = "tenorOne" \tenorOne
    \new Voice = "tenorTwo "\tenorTwo
  >>
  \new Lyrics \with {
    \override VerticalAxisGroup #'staff-affinity = #CENTER
  }
      \lyricsto tenorOne \words
  \new Staff <<
    \set Staff.instrumentName = #"B.B."
    \clef bass
    \new Voice = "baritone" \baritone
    \new Voice = "bass" \bass
  >>
>>
