\version "2.11.49"

\include "english.ly"

myStaffSize = #20

#(set-global-staff-size myStaffSize)

\paper {
   #(set-paper-size "letter")
   #(define fonts
       (make-pango-font-tree "URW Palladio L"
                          "Nimbus Sans"
                          "Luxi Mono"
                           (/ myStaffSize 20)))
   top-margin = 10\mm
}

\header {
	title = "Glory to God on High"
  subtitle = "TTBB"
	poet = \markup {\italic Text: James Allen}
	composer = \markup {\italic Music: Felice de Giardini}
	arranger = \markup  {\italic arr. Andrew Hawryluk}
	copyright = \markup \tiny \override #'(baseline-skip . 2.5) \center-column {
              "©2004 Andrew Hawryluk    www.musicbyandrew.ca"
              "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
              "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"
	}
}

global = {
  \key g \major
  \time 3/4
}

tenorOne = \relative c' {
  \voiceOne
  d4 b g a( g) fs g2.
  g4 a b c8.( d16 c4) b a2.
  d4 b g d2.
  a'4 b c b4. a8 g4
  a4 b c b4. a8 g4
  g4 b d d4. e8 d4 c b a g2. \break

  d'4^\markup \italic "lower voices sing “oo” or “ah”"
  b g a_( g) fs g2.
  g4 a b c8.( d16 c4) b a2.
  d4 b g d2.
  a'4 b c b4. a8 g4
  a4 b c b4. a8 g4
  g4 b d d4. e8 d4 c b a g2. \break

  d'4^\markup \italic "all voices sing the words"
  b g a( g) fs g2.
  g4 a b c8.( d16 c4) b a2.~ a
  d4 d d d2.
  d4 d d d4. c8 b4
  d4 d d ds4. ds8 e4
  g,4 b d d4. e8 d4 e2 d4~ d d2 d2.\fermata
  \bar "|."
}

tenorTwo = \relative c' {
  \voiceTwo
  d4 b g a( g) fs g2.
  g4 a b c8.( d16 c4) b a2.
  d4 b g d2.
  fs4 g a b4. a8 g4
  fs4 g a b4. a8 g4
  g4 b b b4. c8 b4 g g fs g2.

  b2.( c b)
  g~( g fs)
  d~ d
  fs( g) fs( g)
  \shape #'((1.1 . 0.3) (1 . 0) (0 . 0) (0 . 0.3)) Tie
  b~( b4. c8 b4)
  g2( fs4 g2.)

  b4 g g a( g) fs g2.
  g4 g g g2 g4 g2.( fs)
  d'4 b b a2.
  a4 b c b4. a8 g4
  a4 b c b4. a8 g4
  g b b b4. c8 b4 c2 b4~ b a2 b2.\fermata
}

baritone = \relative c' {
  \voiceOne
  d4 b g a( g) fs g2.
  g4 g g g2 g4 g( fs2)
  d'4 b g d2.
  d4 d d g4. g8 g4
  d4 d d g4. g8 g4
  g4 g g g4. g8 g4 e d d g2.

  d2.( e d)
  e~( e d)
  d~ d d( g,) d'( g,)
  g'~ g
  e4( d2 g2.)

  g4 d d e( d) d g2.
  e4 e e e2 e4 d2.~ d
  d'4 b g fs2.
  fs4 g a g4. g8 g4
  fs4 g a fs4. fs8 e4
  g4 g g g4. g8 g4 g2 g4~ g fs2 g2.\fermata
}

bass = \relative c' {
  \voiceTwo
  d4 b g a( g) fs g2.
  g4 g g g2 g4 g( fs2)
  d'4 b g d2.
  d4 d d g4. g8 g4
  d4 d d g4. g8 g4
  g4 g g g4. g8 g4 e d d g2.

  g,2.~ g~ g
  e'( c d)
  d~ d d( g,) d'( g,)
  g'4( d b g2.)
  c4( d2 g2.)

  g,4 g b c( d) d g2.
  e4 e e c2 c4 d2.~ d
  d'4 b g d2.
  d4 d d g,4. g8 g4
  d'4 d d b4. b8 e4
  g4 d8( c) b( a) g4. g8 g4
  c2 d4~ d d2 g,2.\fermata
}

words = \lyricmode {
  \set stanza = \markup \dynamic "mf"
  Glo -- ry to God on high!
  Let heav’n and earth re -- ply.
  Praise ye his name.
  His love and grace a -- dore,
  Who all our sor -- rows bore.
  Sing a -- loud ev -- er -- more:
  Wor -- thy the Lamb!

  \set stanza = \markup \dynamic "mp"
  Je -- sus, our Lord and God,
  Bore sin’s tre -- men -- dous load.
  Praise ye his name.
  Tell what his arm has done,
  What spoils from death he won.
  Sing his great name a -- lone:
  Wor -- thy the Lamb!

  \set stanza = \markup \dynamic "f"
  Let all the hosts a -- bove
  Join in one song __ of love, __
  Prais -- ing his name.
  To him as -- crib -- ed be
  Hon -- our and maj -- es -- ty
  Thru all e -- ter -- ni -- ty:
  Wor -- thy __ the Lamb!
}

\new ChoirStaff \with {
  \override LyricHyphen #'minimum-distance = #1 }
<<
  %#(set-accidental-style 'modern 'ChoirStaff)
  \override ChoirStaff.LyricText #'font-size = #0.5
  \new Staff <<
    \global
    \set Staff.instrumentName = #"T.T."
    \clef "treble_8"
    \new Voice = "tenorOne" \tenorOne
    \new Voice = "tenorTwo "\tenorTwo
  >>
  \new Lyrics \with {
    \override VerticalAxisGroup #'staff-affinity = #CENTER
  }
      \lyricsto tenorOne \words
  \new Staff <<
    \global
    \set Staff.instrumentName = #"B.B."
    \clef bass
    \new Voice = "baritone" \baritone
    \new Voice = "bass" \bass
  >>
>>
