\version "2.13.9"

myStaffSize = #17

#(set-global-staff-size myStaffSize)

\paper {
  #(set-paper-size "letter")
  #(define fonts
       (make-pango-font-tree "URW Palladio L"
                          "Nimbus Sans"
                          "Luxi Mono"
                           (/ myStaffSize 20)))
  top-margin = 8\mm
  markup-system-spacing = #'((basic-distance . 18) (padding . 0.5))
  ragged-last-bottom = ##f
}

\header {
	title = "Be Still, My Soul"
  poet = \markup {\left-column {
    \line {\italic Text: Katharina von Schlegel, b. 1697}
    \line {trans. by Jane Borthwick (1813–1897)}
  }}
	composer = \markup {\right-column {
    \line {\italic Music: Jean Sibelius (1865–1957)}
	  \line {\italic arr. Andrew Hawryluk}
  }}
	copyright = \markup \tiny \override #'(baseline-skip . 2.5) \left-align \center-column {
    \vspace #0.5
    "© 2010 Andrew Hawryluk      www.musicbyandrew.ca"
    "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
    "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"
	}
  tagline = \markup {
    \vspace #2
    \with-url
    #"http://lilypond.org/"
    \line {
      %% 2014 = em dash.
      #(format #f "Music engraving by LilyPond ~a~awww.lilypond.org"
        (lilypond-version)
        (ly:wide-char->utf-8 #x2014)
        )
    }
  }
}

\include "bestill-defs.ily"

vocals = <<
    \new Staff <<
      \set Staff.instrumentName="Female"
      \set Staff.midiInstrument="string ensemble 1"
      \global
      {\new Voice = "female" \femaleMusic }
      >>
    \new Lyrics \lyricsto "female" \femaleWords
    
    \new Staff <<
      \set Staff.instrumentName="Male"
      \set Staff.midiInstrument="string ensemble 1"
      \global
      {\new Voice = "male" \maleMusic }
      >>
    \new Lyrics \lyricsto "male" \maleWords
>>

pianostaff = \new PianoStaff {
	\set PianoStaff.midiInstrument = #"acoustic grand"
	\set PianoStaff.connectArpeggios = ##t
	<<
		\context Staff = "RH" {  % Right hand 
			\set Staff.connectArpeggios = ##t
			<<
			\new Voice << \global \RightHandOne >>
			\new Voice \RightHandTwo
			>>
		}
		\context Staff = "LH" {  % Left hand
      \clef bass
			\set Staff.connectArpeggios = ##t
			<<
			\new Voice \LeftHandOne
			\new Voice << \global \LeftHandTwo >>
			>>
		}
	>>
}

\book {
  \score {
    <<
      \vocals
      \pianostaff
    >>
  
    \layout {
      \context {
        \RemoveEmptyStaffContext
      }
    }
  }
}

#(define output-suffix "vocals")
\book {
  \score {
    <<
      \vocals
    >>
    
    \layout {
      \context {
        \Score
        \override SpacingSpanner
                #'base-shortest-duration = #(ly:make-moment 1 16)
      }

      \context {
        \RemoveEmptyStaffContext
      }
    }
  }
}

#(define output-suffix "piano")
\book {
  \score {
    <<
      \pianostaff
    >>
  }
}
