\include "english.ly"

up = \change Staff = "RH"
down = \change Staff = "LH"

nudge = #(define-music-function (parser location amount) (number?)
#{
	\once \override Voice.DynamicText #'X-offset = #amount
#})

ftempomark = \markup {\concat {"f" {\normal-text \italic "  a tempo"}}}
ftempo = #(make-dynamic-script ftempomark)

global = {
  \compressFullBarRests
  \override MultiMeasureRest #'expand-limit = 1
  \override Score.PaperColumn #'keep-inside-line = ##t
  \time 4/4
  \key f \major
  \once \override Score.RehearsalMark #'self-alignment-X = #-1
	\once \override Score.RehearsalMark #'break-align-symbols = #'(time-signature)
	\once \override Score.TimeSignature #'break-align-anchor-alignment = #LEFT
	\once \override Score.RehearsalMark #'padding = #1
  \mark \markup {\bold \large "Andante" \hspace #1 {\override #'(font-size . -1)
    {\raise #0.6 \note #"4" #0.9 "= 92" }}}
  s1*28
  \bar "||"
  \key d \major
  s1*20
  \time 2/4
  s2
  \time 4/4
  s1*3
  \time 2/4
  s2
  \time 4/4
  s1
  \time 2/4
  s2
  \time 4/4
  s1*2
  \bar "||"
  \key e \major
  s1*21
  \time 2/4
  s2
  \time 4/4
  s1*7
  \bar "|."
}

femaleMusic = \relative c'' {
  \dynamicUp
  R1*2
  
  r4 a\p g a
  bf2. a4
  g a f4. g8
  g4( a2.)
  r4 f e c
  d2( f4) g
  g f d4. e8
  f1
  r4 f a g f2. f4
  g f e c
  c( d2.)
  r4 d c c
  c2 f
  f4 f e d
  cs1
  r4 c! a' g
  f2. f4
  f e e4. d8
  d1
  r4 d c c
  c2 f
  f4^\markup \italic "rit." f e4. f8
  f1~^\markup \italic "a tempo"
  f4 r4 r2
  
  R1
  
  r4 fs\mf e fs
  g2. fs4
  e fs d4. e8
  e4( fs2.)
  r4 fs e fs
  g2. fs4
  e fs d4. e8
  fs1
  r4 a a a
  b2. fs4
  fs a a4. e8
  e4( g2.)
  r4 g fs e
  fs2. d4
  d\> e e4. fs8
  fs1
  r4\! a\mp a a
  b2. \breathe fs4
  fs a a4. e8
  \phrasingSlurDashed
  e4( g2)\( g4\) fs e
  fs2 d \breathe
  d4^\markup \italic "rit." e e4. d8
  d1~^\markup \italic "a tempo" d4 r4
  
  R1 R2 R1*2
  
  r4 \once \override DynamicText #'X-offset = #-3
    gs^\markup \italic "both voices unison"\f fs gs
  a2. gs4
  fs gs e4. fs8
  fs4( gs2.)
  r4 gs fs gs
  a2. gs4
  fs gs e4. fs8
  gs1
  r4 b b b
  cs2. gs4
  gs b b4. fs8
  fs4(\> a2.)
  r4\! a\mf gs fs
  gs2. e4
  e\< fs fs4. gs8
  gs1
  r4\! b\f b b
  cs2. \breathe gs4
  gs b b4. fs8
  << {\once \override Slur #'positions = #'(-2.5 . -2) fs4( a2.~}
     \new Voice {s2 s2^\markup \italic "poco rit."}
     >> a1~ a4) r4
  r4 \once \override DynamicText #'X-offset = #-5
    a\mp^\markup \italic "rubato" gs fs  
  gs2 e \breathe
  e4 fs fs4.^\markup \italic "rit." e8
  e1~^\markup \italic "a tempo" e2 r2 R1*2
}

maleMusic = \relative c' {
  \dynamicUp
  \clef "treble_8"
  R1*2
  
  r4 a\p g a
  bf2. a4
  g a f4. g8
  g4( a2.)
  r4 \once \override Voice.DynamicText #'extra-offset = #'(-2 . -1) 
    a\mp g a
  bf2. a4
  g a f4. g8
  a1
  r4 c c c
  d2. a4
  a c c4. g8
  g4( bf2.)
  r4 bf a g
  a2. f4
  f g g4. a8
  a1
  r4 c c c
  d2. a4
  a c c4. g8
  g4( bf2.)
  r4 bf a g
  a2. f4
  f g g4. f8
  f1~
  f4 r4 r2
  
  R1
  
  R1
  r4 d'\mf cs a
  g1
  r4 a a cs
  cs d d2~
  d4 cs b a
  g a b b
  a1
  r4 a d cs
  b( cs d) d
  d cs cs4. a8
  a4( b2.)
  r4 b a g
  a2. fs4
  b\> b b4. b8
  b4( as2.)
  r4\! a!\mp d cs
  b2. \breathe b4
  b fs fs4. a8
  \phrasingSlurDashed
  a4( b2)\( b4\) a g
  a2 fs \breathe
  g4 b cs4. d8
  d1~ d4 r4
  
  R1 R2 R1*2
  
  \set Staff.keepAliveInterfaces = #'()
  r4 gs,\f fs gs
  a2. gs4
  fs gs e4. fs8
  fs4( gs2.)
  r4 gs fs gs
  a2. gs4
  fs gs e4. fs8
  gs1
  r4 b b b
  cs2. gs4
  gs b b4. fs8
  fs4(\> a2.)
  r4\! a\mf gs fs
  gs2. e4
  e\< fs fs4. gs8
  gs1
  r4\! b\f b b
  cs2. \breathe gs4
  gs b b4. fs8
  fs4( a2.~ a1~ a4) r4
  r4 a gs fs  
  gs2 e \breathe
  e4 fs fs4. e8
  e1~ e2 r2 R1*2
}

femaleWords = \lyricmode {
  Be still, my soul:
  The Lord is on thy side;
  With pa -- tience bear thy cross of grief or pain.
  Leave to thy God to or -- der and pro -- vide;
  In ev -- ’ry change he faith -- ful will re -- main.
  Be still, my soul:
  Thy best, thy heav’n -- ly Friend
  Thru thorn -- y ways leads to a joy -- ful end. __

  Be still, my soul:
  Thy God doth un -- der -- take
  To guide the fu -- ture as he has the past.
  Thy hope, thy con -- fi -- dence let noth -- ing shake;
  All now mys -- te -- rious shall be bright at last.
  Be still, my soul:
  The waves and winds still know
  His voice who ruled them while he dwelt be -- low. __

  Be still, my soul:
  The hour is has -- t’ning -- on
  When we shall be for -- ev -- er with the Lord,
  When dis -- ap -- point -- ment, grief, and fear are gone,
  Sor -- row for -- got, love’s pur -- est joys re -- stored.
  Be still, my soul:
  When change and tears are past, __
  All safe and bless -- ed we shall meet at last. __
}

maleWords = \lyricmode {
  Be still, my soul:
  The Lord is on thy side;
  With pa -- tience bear thy cross of grief or pain.
  Leave to thy God to or -- der and pro -- vide;
  In ev -- ’ry change he faith -- ful will re -- main.
  Be still, my soul:
  Thy best, thy heav’n -- ly Friend
  Thru thorn -- y ways leads to a joy -- ful end. __

  Be still, my soul:
  Thy God doth un -- der -- take
  To guide the fu -- ture as the past.
  Thy hope, thy con -- fi -- dence let noth -- ing shake;
  All now mys -- te -- rious shall be bright at last.
  Be still, my soul:
  The waves and winds still know
  His voice who ruled them while he dwelt be -- low. __
  
  \set Lyrics . keepAliveInterfaces = #'()
  
  Be still, my soul:
  The hour is has -- t’ning -- on
  When we shall be for -- ev -- er with the Lord,
  When dis -- ap -- point -- ment, grief, and fear are gone,
  Sor -- row for -- got, love’s pur -- est joys re -- stored.
  Be still, my soul:
  When change and tears are past, __
  All safe and bless -- ed we shall meet at last. __
}

RightHandOne = \relative c' {
  R1*6
  c'1
  <d, f c'>1
  \voiceOne c'2 \oneVoice <f, bf>4 <g c>4
  <c, g' a>1
  a'4 c <f, c' f> <f c' e>
  <f a d> <g a e'> <a d f>2
  \voiceOne c1 \oneVoice
  R1
  d2 c,
  <f c'>2 c8 f a c
  r2 bf,8 d f g
  r2 cs,8 e a4
  <f! a>2 c8 f a c
  d1
  <f, c'>2 <e c'>
  <bf' d>2 d,8 g bf d
  g2 c,,
  r2 c'8 a c,4
  r2_\markup \italic "rit." g'8 e c4
  r4_\markup \italic "a tempo" <f a> <f g> <f a>
  \voiceOne 
  bf\< c d e
  e1
  
  <d fs>2\mf d
  \oneVoice <b d> <a cs d>
  <g a d>1
  <e a cs>4 <fs a d>2 <a cs e>4
  <a cs e> <a d fs> \voiceOne <a a'>2
  <d a'>2 d
  \oneVoice <g, d'>2 <b, d>4. d8
  <fs, a>4 <a' a'>( <d d'> <cs cs'>
  <a cs a'> <fs fs'>) <fs fs'>( <e e'>)
  <d d'>( <e e'> <fs fs'> <b b'>)
  <b b'>( <a a'>) <fs fs'>2
  <g a d g>1
  e2 <a, d>4-- <b d>--
  <fs a d>4-- <a d fs> <d fs a> <a' d>
  <g a d>2\> g8 d g a
  b4. as8 cs fs as cs
  d2\mp <fs,, a>4 <fs a>
  <d fs b> <e fs cs'> <fs b d> <b d fs>
  <b cs fs> <a cs fs>2 <a cs>4
  <g a d>2. d4^~
  <a d> <b d>
  <a d>2 <d a'>
  <g, b>4_\markup \italic "rit." d' cs4. d8
  r4_\markup \italic "a tempo" <d' fs> <d e> <a d fs>
  <b d g>2~ <b d g>4 <b d g>_\markup \italic "cresc." <b d fs> <b d g>
  <a cs fs a>2~ <a cs fs a>4 <a fs' a> <gs e' gs>_\markup \italic "rit." <a e' a>
  <b e fs b>4\< <fs b cs>8 e' <fs, b ds>4 <cs' e>8 <ds fs>
  
  \once \override  TextScript #'X-offset = #3
  <b e gs>4\ftempo <e, gs b> <ds fs b> <e gs b>
  <cs e a b>2. <b e gs b>4
  \voiceOne <ds fs> <e gs> \oneVoice <cs e b'>4. <ds fs b>8
  <ds fs b>4 <e gs b> <e gs b> <fs b ds>
  <fs b ds> <gs b e> <fs b ds> <e gs b>
  <cs e a b>1
  <fs, b ds>4 <gs b e> \voiceOne e'8 b' fs b
  gs4 fs fs b \oneVoice
  <e, gs> b' <b fs'> <fs b ds>
  <gs cs e> <fs ds'> <e cs'> <ds b'>
  <cs gs' as> <b gs'> fs' ds
  \voiceOne e\> fs gs a
  b2\! \oneVoice <b, e>4\mf <cs e>
  e2 e8 fs gs b
  <e, b' cs>2\< \voiceOne ds'4 ds \oneVoice
  <fs, gs cs ds>2 <ds gs bs>4 ds'
  <gs, b! e>2\f <e gs b>4 <fs b fs'>
  <gs e' gs> <fs fs'> <e e'> <b' b'>
  <as ds as'> <gs gs'> <fs fs'> <gs gs'>
  <a cs a'>2 <fs a cs>4_\markup \italic "poco rit." <fs a cs ds>
  \voiceOne e'\> fs a gs
  e2~\! e2 \oneVoice <gs,, a e'>\mp
  \voiceOne r4 b' b' b, \oneVoice
  <b, cs e>2 <b ds>4._\markup \italic "rit." e8
  r4_\markup \italic "a tempo" <e gs> <e fs> <e gs>
  \voiceOne a b cs_\markup \italic "rit." e \oneVoice
  <b e gs>1\arpeggio_\markup \italic "a tempo"
  e1
}

RightHandTwo = \relative c'' {
  \voiceTwo
  s1*8
  g4( f) s2
  s1*3
  g4( f e2)
  s1*13
  <d f>2 <f bf>
  <bf d>4 <a cs>8 <g b> <a cs>4 <b d>8 <cs e>
  r4 a g a
  s1*3
  s2 e'4 d
  b a g fs
  s1*14 s2 s1*6
  s1*2
  s1
  <b, b'>2 s2
  s1*3
  s2 <a b>4 b
  e1
  s1*3
  cs2 <cs e>~
  <cs e> s
  s1
  s2 <fs cs'>
  s1*5
  <fs a cs>1
  <gs a>2~ <gs a> s2
  <b, e>1
  s1*2
  <cs e>2 <e a>
}

LeftHandOne = \relative c' {
  \voiceOne
  s1*42
  d8 b d e
  s1*35 s2
  gs,8 fs gs b e2
  s1*3
  r8 b, e gs \stemUp b \up \stemDown e gs b
}

LeftHandTwo = \relative c, {
  \set Staff.pedalSustainStyle = #'bracket
  f8^\p_\markup \italic "with pedal"
  c'^\markup \italic {use both hands here}
  f a c a f c
  f, c' f a c a f c
  f, c' f a c a f c
  f, d' f bf c bf f d
  f, e' g c f e c g
  f, c' f g \stemUp a \up \stemDown c f g \down \stemNeutral
  f,, c' f a \up c g' f c \down
  f,, d' f bf \up d f g c \down
  a,, f' a e d f e c
  f, c' g' f \up d' c f g \down
  f,, c' f g a c a a,
  d, a' d f a d, f a
  a, f'4 a8 a, e' a c
  g,\sustainOn d' g bf \stemUp d \up \stemDown g a bf \down \stemNeutral
  r2 <a,, f'>4\sustainOff <bf g'>
  c8 f g a r2
  bf,8 d f g r2
  a,8 e' b' a~ a4 a,8 g
  f c' f a~ a4 e,4
  d8 a' d f \stemUp a \up \stemDown d f a \down \stemNeutral
  a,, f' a c a, e' a c
  g,\sustainOn d' g bf r2
  r2 <a, fs'>4\sustainOff <bf g'>
  c8 f a c~ c4 r8 f,
  c f g c c,2
  f,8 c' f a c a f c
  f, d' f bf d bf f d
  a e' a e a e a, a,
  
  d a' d fs a d fs, a,
  d, b' d g d' g, d b
  e, b' d e \stemUp g b d \up \stemDown a' \down \stemNeutral
  d,,, a' d fs a fs d a
  d, a' d fs d' a fs d
  g, d' g a b g d a
  e b' e g a, e' g4
  d,8 a' d fs a fs d a
  d, a' d a' d, a' cs, a'
  b, fs' b cs d b fs b,
  fs cs' fs a cs a fs cs
  e,\sustainOn b' e g b a b d
  r2 <fs,, d'>4--\sustainOff <g d'>--
  <a, a'>1--
  \voiceTwo g''1 \oneVoice
  fs8 cs' fs2 <e, fs as>4
  <d fs a!>2 d'4 <cs d>
  b8 fs b, fs b,2
  fs'8 cs' fs a gs fs cs fs,
  e\sustainOn b' d e g b r4
  <fs, d'>4\sustainOff <g d'>
  a8 d fs a r2
  a,8 d g b a, e' a4
  d,,8 a' d fs a fs d a
  d, g b d g b d b g d b g
  cs, fs cs' fs a cs e cs a e cs e,
  b fs' b fs' b fs b, fs
  
  <e, e'> b'' e gs b gs e b
  e, cs' e a b a e b
  e, b' e gs a e cs b
  e, b' e gs b gs e b
  e, b' e gs b gs e b
  \stemUp e, cs' e \up \stemDown a b cs e \down \stemUp e, \stemNeutral
  e, b' e b cs4 ds4
  e,8 b' e gs b gs e b
  e, b' gs' e ds, b' fs' b,
  cs, gs' cs e gs cs, e gs
  gs, ds' gs as b gs fs b,
  a e' a gs, fs\sustainOn cs' fs a
  cs2 <gs, e'>4\sustainOff <a fs'>
  b8 e gs b r2
  a,8 e' a b a, e' a e
  gs, ds' gs as gs ds gs, fs
  e b' e gs e b ds ds,
  cs gs' cs e gs cs gs cs,
  gs ds' gs b gs ds b ds
  fs, cs' fs a fs cs e, a
  d,\sustainOn a' d e fs a cs e
  r2 r2 <fs,, cs'>\sustainOff
  \voiceTwo b1 \oneVoice
  b8 fs' a cs b, fs' b4
  e,,8 b' e gs b gs e b
  e, cs' e a b a fs b,
  e,1~ e
}