\version "2.15.1"
\language "english"

\include "arise.ily"

myStaffSize = #18

#(set-global-staff-size myStaffSize)

\paper {
  #(define fonts
     (make-pango-font-tree "Minion Pro"
                        "Nimbus Sans"
                        "Luxi Mono"
                        (/ myStaffSize 20)))
  #(set-paper-size "letter")
  %left-margin = 15\mm % only for large score
  ragged-last-bottom = ##f
  top-margin = 10\mm
  markup-system-spacing #`basic-distance = #20
}

\header {
  title = "Arise and Shine Like a Light upon a Hill"
  dedication = \markup \italic
  \override #'(baseline-skip . 1.8) \center-column
  {
    "Written for the Calgary Temple Cultural Celebration"
    "held October 27, 2012. Dedicated to all the youth."
    \vspace #1.5
  }
  composer = \markup \lower #2 { \italic "Music:" "Andrew Hawryluk" }
  poet = \markup \lower #2 { \italic "Words:" "Andrew Hawryluk and Jane Conrad" }
  copyright = \markup \small \override #'(baseline-skip . 2.2) \center-column {
    "© 2012 Andrew Hawryluk      www.musicbyandrew.ca"
    "You can share and modify this work under the Creative Commons Attribution-Noncommercial 3.0 License."
    "To view a copy of this license, visit http://creativecommons.org/licenses/by-nc/3.0/"
  }
}


youth = <<
  \new Staff %\with { instrumentName = #"Youth" shortInstrumentName = #"" }
    <<
      \set Staff.midiInstrument = #"soprano sax"
      \global
      \new Voice = "melody" \melody
    >>
    \new Lyrics \lyricsto "melody" {
      \verseI \verseII \chorus
      \lyricmode {
        -til the bright of day.
        Press -- ing for -- ward with faith
        and the love of our Sav -- iour,
        Lift -- ing the bur -- dens that we see, __
        As we walk in the light of the love of the Lord,
        He will shine through you and me!
        We will
      }
      \chorus
      \coda
    }
    \new Lyrics \lyricsto "melody" \verseIII
>>

choir = \new ChoirStaff
    <<
      \new Staff %\with { instrumentName = #"SA" shortInstrumentName = #"SA" }
      <<
        \set Staff.midiInstrument = #"viola"
        \clef "treble"
        \new Voice = "soprano" << \global \soprano >>
        \new Voice << \global \alto >>
      >>
      \new Lyrics \lyricsto "soprano" {
        \verseI \verseII \chorus
        \lyricmode {
          -til the bright of day.
          Press -- ing for -- ward with faith
          and the love of our Sav -- iour,
          Lift -- ing the bur -- dens that we see, __
          As we walk in the light of the love of the Lord,
          He will shine through you and me!
          We will
        }
        \chorus
        \coda
      }
      \new Lyrics \lyricsto "soprano" \verseIII
      \new Staff %\with { instrumentName = #"TB" shortInstrumentName = #"TB" }
      <<
        \set Staff.midiInstrument = #"viola"
        \clef "bass"
        \new Voice << \global \tenor >>
        \new Voice << \global \bass >>
      >>
    >>
    
    
piano = \new PianoStaff %\with { instrumentName = #"Piano" shortInstrumentName = #"Pno" }
    <<
      \new Staff = "right" <<
        \global
        \new Voice = "rightOne" \rightOne
        \new Voice = "rightTwo" \rightTwo
      >>
      \new Staff = "left" <<
          \global
          \new Voice \leftOne 
          \new Voice \leftTwo
        >>
    >>

\book {
  \paper {
    markup-system-spacing #`basic-distance = #35
  }
  \header {
    subtitle = "One- or two-part version"
  }
  \score {
    <<
      \youth
      \piano
    >>
    \layout {
      \context {
        \Staff \RemoveEmptyStaves
        \override VerticalAxisGroup #'remove-first = ##t        
      }
    }
  }
}

\book {
  \bookOutputSuffix "SATB"
  \header {
    subtitle = "SATB version"
  }
  \score {
    <<
      \choir
      \piano
    >>
    \layout {
    }
  }
}

\book {
  \bookOutputSuffix "SATBpart"
  \paper {
    markup-system-spacing #`basic-distance = #35
    system-system-spacing #`basic-distance = #15
    ragged-last-bottom = ##t
  }
  \header {
    subtitle = "SATB version"
  }
  \score {
    <<
      \choir
    >>
    \layout {
    }
  }
}

\book {
  \bookOutputSuffix "piano"
  \paper {
    markup-system-spacing #`basic-distance = #25
  }
  \header {
    subtitle = "Piano"
    dedication = ##f
  }
  \score {
    <<
      \piano
    >>
    \layout {
    }
  }
}